#pragma once

#include "global.h"
#include "texture.h"

enum Align
{
	Left,
	Center,
	Right
};

class Font
{
public:
	Font(void);
	~Font(void);

	bool Create();
	bool Create(const string &szTTFFilename);

	void Render(const string &str, int x, int y, dword height, dword style = XFONT_NORMAL, int dwMaxWidth = -1, bool fade = false, Align alignment = Left);
	void RenderToTexture(Texture &texture, const string &str, dword height, dword style = XFONT_NORMAL, int maxWidth = -1, bool fade = false);
	
	int GetRequiredWidth(const string &str, dword height, dword style);
	int GetRequiredHeight(const string &str, dword height, dword style);

	word *StringToWChar(const string &str);

private:
	XFONT *m_pFont;
};

extern Font g_font;